﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Obroty wg magazynów</title>

    <script runat="server">

		public class ParameterClass
			: ContextBase
		{
			private Magazyn[] _magazyny;

			private FromTo _okres;

			[Priority(10)]
			[Caption("Magazyny")]
			[System.ComponentModel.Browsable(true)]
			public Magazyn[] Magazyny
			{
				get
				{
					return this._magazyny;
				}
				set
				{
					this._magazyny = value;
				}
			}

			[Priority(20)]
			[Caption("Okres")]
			[System.ComponentModel.Browsable(true)]
			public FromTo Okres
			{
				get
				{
					return this._okres;
				}
				set
				{
					this._okres = value;
				}
			}

			public ParameterClass(Context context)
				: base(context)
			{
				ObrotyParams op;
				if (context.Get<ObrotyParams>(out op))
				{
					this._okres = op.Okres.Okres;
					if (op.Magazyn != null)
					{
						this._magazyny = new Magazyn[] { op.Magazyn };
					}
				}
				else
				{
					Magazyn m;
					if (context.Get<Magazyn>(out m))
					{
                        if( m != null )
						    this._magazyny = new Magazyn[] { m };
					}
					this._okres = YearMonth.Today.ToFromTo();					
				}
			}
		}

		private ParameterClass _parameter;

		[Context]
		public ParameterClass Parameter
		{
			get
			{
				return this._parameter;
			}
			set
			{
				this._parameter = value;
			}
		}

		void DataContext_ContextLoad(Object sender, EventArgs args)
		{
			if (this.Parameter.Magazyny.Length == 0)
			{
				throw new InvalidOperationException("Nie wybrano żadnego magazynu dla raportu.");
			}
			this._rh.Title = string.Format(this._rh.Title, Format(this.Parameter.Magazyny), this.Parameter.Okres);
			this._grid.DataSource = new ListWithView(this.Parameter.Magazyny,
				HandelModule.GetInstance(this.Parameter).Magazyny.Magazyny.WgNazwa);
		}

		private static string Format(Magazyn[] magazyny)
		{
			StringBuilder sb = new StringBuilder();
			foreach (Magazyn m in magazyny)
			{
				sb.AppendFormat(" {0},", m);
			}
			return sb.ToString().TrimStart().TrimEnd(',');
		}

		void Grid_ItemsGet(Object sender, ItemsGetEventArgs args)
		{
			if (args.Deep == 1)
			{
				Magazyn m = args.Row as Magazyn;
				if (m != null)
				{
					Soneta.Business.View vw = HandelModule.GetInstance(m).DokHandlowe.WgMagazyn[m].CreateView();
					if (this.Parameter.Okres != FromTo.Empty
						&& this.Parameter.Okres != FromTo.All)
					{
						vw.Condition &= new FieldCondition.Contain("Data", this.Parameter.Okres);
					}
					args.Enumerable = vw;
					PoliczWartosc(this._dlWartoscPrzed, m, this.Parameter.Okres.From, -1);
					PoliczWartosc(this._dlWartoscPo, m, this.Parameter.Okres.To, 0);
				}
			}
		}

		private static void PoliczWartosc(DataLabel label, Magazyn magazyn, Date date, int addDays)
		{
			Currency d = label.EditValue is Currency ? (Currency)label.EditValue : Currency.Zero;
			d += PoliczWartosc(magazyn, date, addDays);
			label.EditValue = d;
		}

		private static Currency PoliczWartosc(Magazyn magazyn, Date date, int addDays)
		{
			if (date == Date.MinValue)
			{
				return Currency.Zero;
			}
			else
			{
				Currency d = Currency.Zero;
				StanMagazynuWorker smw = new StanMagazynuWorker();
				foreach (Towar t in magazyn.Module.Towary.Towary)
				{
					smw.Towar = t;
					smw.Magazyn = magazyn;
					smw.Data = date == Date.MaxValue ? Date.Empty : date.AddDays(addDays);
					d += new DoubleCy(smw.WartośćMagazynu).RoundCy();
				}
				return d;
			}
		}

		private void Grid_BeforeRow(object sender, RowEventArgs args)
		{
			DokumentHandlowy dok = args.Row as DokumentHandlowy;
			args.VisibleRow = dok != null && dok.TypPartii == TypPartii.Magazynowy;
			if (args.VisibleRow)
			{
				this._colWartosc.EditValue = dok.WartośćWCenieZakupuBufor * (int)dok.KierunekMagazynu;
				switch (dok.KierunekMagazynu)
				{
					case KierunekPartii.Przychód:
						{
							this._colRozchod.EditValue = 0m;
							this._colPrzychod.EditValue = dok.WartośćWCenieZakupuBufor;
							break;
						}
					case KierunekPartii.Rozchód:
						{
							this._colRozchod.EditValue = dok.WartośćWCenieZakupuBufor;
							this._colPrzychod.EditValue = 0m;
							break;
						}
				}
			}
		}

    </script>

    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server">
        <ea:datacontext runat="server" oncontextload="DataContext_ContextLoad"></ea:datacontext>
        <eb:reportheader runat="server" id="_rh" title="Obroty w magazynach wg dokumentów|</strong>Magazyny: <strong>{0}|</strong>Okres: <strong>{1}</strong>"></eb:reportheader>
        <ea:grid runat="server" id="_grid" rowtypename="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
            onitemsget="Grid_ItemsGet" groupline="Magazyn: {0}" groupdata0="Magazyn" showgroupsum="True"
            onbeforerow="Grid_BeforeRow" encodehtml="true">
		<Columns>
			<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." EncodeHTML="True"
				runat="server">
			</ea:GridColumn>
			<ea:GridColumn DataMember="Kontrahent" Caption="Kontrahent" EncodeHTML="True" runat="server">
			</ea:GridColumn>
			<ea:GridColumn DataMember="Numer" Caption="Dokument" EncodeHTML="True" runat="server">
			</ea:GridColumn>
			<ea:GridColumn DataMember="Data" Total="Info" Caption="Data dokumentu" EncodeHTML="True"
				runat="server">
			</ea:GridColumn>
			<ea:GridColumn Align="Right" Total="Sum" Caption="Przychód" Format="{0:n}" EncodeHTML="True"
				runat="server" ID="_colPrzychod">
			</ea:GridColumn>
			<ea:GridColumn Align="Right" Total="Sum" Caption="Rozchód" Format="{0:n}" EncodeHTML="True"
				runat="server" ID="_colRozchod">
			</ea:GridColumn>
			<ea:GridColumn Width="14" Align="Right" Total="Sum" Caption="Wartość" Format="{0:n}"
				EncodeHTML="True" runat="server" ID="_colWartosc">
			</ea:GridColumn>
		</Columns>
	</ea:grid>
        <div style="text-align: right;">
            <table style="width: 50%; font-size: 13px;">
                <tbody>
                    <tr>
                        <th style="text-align: left;">Wartość na początku okresu:
                        </th>
                        <td style="text-align: right;">
                            <ea:datalabel id="_dlWartoscPrzed" runat="server">
						</ea:datalabel>
                        </td>
                    </tr>
                    <tr>
                        <th style="text-align: left;">Wartość na koniec okresu:
                        </th>
                        <td style="text-align: right;">
                            <ea:datalabel id="_dlWartoscPo" runat="server">
						</ea:datalabel>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <eb:reportfooter runat="server"></eb:reportfooter>
    </form>
</body>
</html>
